** @name csdtype.d Defines CSD device type numbers.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created.

** @section Introduction
*
* The Configuration Status Descriptor (CSD) contains information
* about the names and types of devices currently available
* on the CD-i player.
*
* The only devices with fixed names are the NVRAM and PIPE devices,
* whose names are {@c nvr} and {@c pipe}, respectively.
*
* The names of all other devices will vary depending on the CD-i player
* model and configuration and must be obtained from the CSD.
*
* The name of the CSD file is always {@c /nvr/csd}.
*
* @author CD-i Fan

* @section Device type constants

DT_SYSTEM	equ	0		System
DT_CDC		equ	1		CD device
DT_AUDIO		equ	2		Audio device
DT_VIDEO		equ	3		Video device
DT_NVRAM 	equ	4		Non-volatile RAM device
DT_PTR		equ	5		Pointing device
DT_CDPLAY 	equ	6		CD Player device
DT_AUDSET	equ	7		Audio Set device
DT_DISPLY	equ	8		Display monitor device
DT_PIPEDEV 	equ	9		Pipe device

DT_KEYBRD	equ	10		Keyboard device
DT_SERIAL	equ	20		Serial device
DT_RAM		equ	30		RAM device
DT_MPEGVID	equ	90		MPEG Video device
DT_MPEGAUD	equ	91		MPEG Audio device

