** @name stubcore.s Implements stub core functions.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		use		"stubdefs.d"

		psect		stubcore,0,0,0,0,0

		align

** Performs stub protocol
*
* The basic protocol variables are kept in registers:
*
* @var d0-d2 Scratch registers.
* @var d3.l Write limit.
* @var d4.l Read limit.
* @var d5.l Available for register mask.
* @var d6.l Check byte in bits 0-7, request type in bits 16-23.
* @var d7.l Available.
*
* @var a0-a2 Scratch registers.
* @var a3 End of write routine.
* @var a4 Current address.
* @var a5 Available for registers.
* @var a6 Global variables.

stub:
* Initialize character i/o.
		bsr		ioinit

* Write version message.
		bsr		wrtext
		lea		stubver(pc),a0
		bsr		wrtext

* Initialize saved registers.
		bsr		initregs

* Announce stub activation.
		moveq		#STUB_EM,d0
		bsr		wrchar
		
* Clear current address and read/write counts
		moveq		#0,d0
		moveq		#-1,d1
		move.l	d0,a3
		move.l	d1,a4
		moveq		#0,d3
		moveq		#0,d4

** Waits for request.
stubreq:
		moveq		#0,d6

		bsr		rdbyte
		cmpi.b	#STUB_SOH,d0
		beq.s		stubtype

		cmpi.b	#STUB_ACK,d0
		beq.s		stubreq
		cmpi.b	#STUB_NAK,d0
		beq.s		stubreq

* Process data byte.
		bsr		prdata
		bra.s		stubreq

** Get request type.
stubtype:
		bsr		rdbyte
		swap		d6
		move.b	d0,d6
		swap		d6

* Dispatch request.
		cmpi.b	#STUB_WRITE,d0
		beq.s		stubwrite
		cmpi.b	#STUB_ADDRESS,d0
		beq.s		stubaddr
		cmpi.b	#STUB_EXECUTE,d0
		beq		stubexec
		cmpi.b	#STUB_END,d0
		beq		stubend
		cmpi.b	#STUB_ESCAPE,d0
		beq		stubesc
		cmpi.b	#STUB_BAUDRATE,d0
		beq		stubbaud
		cmpi.b	#STUB_READ,d0
		beq		stubread
		cmpi.b	#STUB_BUFFER,d0
		beq		stubbuf
		cmpi.b	#STUB_REGISTERS,d0
		beq		stubregs
		cmpi.b	#STUB_OS9CALL,d0
		beq		stubos9
		cmpi.b	#STUB_CALL,d0
		beq		stubcall
		
** Sends negative acknowledgement.
stubnak:
		moveq		#STUB_NAK,d0
		bsr		wrchar
		bra		stubreq

** Sends positive acknowledgement.
stuback:
		bsr		wrack
		bra		stubreq

** Sets current address.
stubaddr:
		bsr		rdlong
		move.l	d0,a0

		bsr		rdcheck
		bcs.s		stubnak

* Sets address and unlimited read/write counts.
stubset:
		moveq		#0,d0
		move.l	d0,a3
		move.l	a0,a4
		moveq		#-1,d3
		moveq		#-1,d4

		bra.s		stuback

** Writes data.
stubwrite:
		bsr		rdword
		move.l	a4,a2
		move.l	d3,d2
		move.l	d0,d1
		beq.s		write3
write1
		bsr		rdbyte
		tst.l		d2
		beq.s		write2
		move.b	d0,(a2)+
		subq		#1,d2
write2
		subq		#1,d1
		bne.s		write1
write3
		bsr		rdcheck
		bcs.s		stubnak

		move.l	a2,a4
		move.l	d2,d3
		bne.s		write4
		move.l	a3,d0
		beq.s		write4
		jsr		(a3)
		moveq		#0,d0
		move.l	d0,a3
write4
		bra.s		stuback

** Executes program.
stubexec:
		bsr		rdlong
		move.l	d0,a0

		bsr		rdcheck
		bcs.s		stubnak

		bsr		wrack

		move.l	-(sp),a6
		jsr		(a0)
		move.l	(sp)+,a6

		moveq		#STUB_EM,d0
		bsr		wrchar

		move		a4,d0
		bra.s		stubset

** Ends "stub" program.
stubend:
		bsr		rdcheck
		bcs		stubnak

		bsr		wrack

		bra		stubret

** Escapes data.
stubesc:
		bsr		rdbyte
		move.b	d0,d1

		bsr		rdcheck
		bcs		stubreq

* Process data byte.
		bsr		prdata

		bra		stubreq

** Sets baudrate.
stubbaud:
		bsr		rdlong
		move.l	d0,d2

		bsr		rdcheck
		bcs		stubnak

		bsr		wrack

		move.l	d2,d0
		bsr		iocheck
		move.l	d0,d1

baud0
		bsr		wrhdr

		move.l	d1,d0
		bsr		wrlong
		
		bsr		wrcheck

		bsr		rdchar
		cmp.b		#STUB_NAK,d0
		beq.s		baud0
		cmp.b		#STUB_ACK,d0
		bne.s		baud1
		
		bsr		iobaud
baud1
		bra		stubreq

* Reads data.
stubread:
		bsr		rdword
		move.l	d0,d2

		bsr		rdcheck
		bcs		stubnak

		bsr		wrack

read0
		bsr		wrhdr

		move.l	d2,d0
		bsr		wrword

		move.l	a4,a1
		move.l	d4,d1
		tst.l		d2
		beq.s		read3

read1
		moveq		#0,d0
		tst.l		d1
		beq.s		read2
		move.b	(a1)+,d0
		subq		#1,d1
read2
		bsr		wrbyte

		subq		#1,d2
		bne.s		read1

read3
		bsr		wrcheck

		bsr		rdchar
		cmp.b		#STUB_NAK,d0
		beq.s		read0
		cmp.b		#STUB_ACK,d0
		bne.s		read4
		
		move.l	a1,a4
		move.l	d1,d4
		
read4
		bra		stubreq

** Sets buffer address.
stubbuf:
		bsr		rdword
		move.l	d0,d2

		bsr		rdcheck
		bcs		stubnak

		bsr		wrack

		move.l	d2,d0
		bsr		allocbuf
		move.l	d0,d2
				
buf0
		bsr		wrhdr

		move.l	d2,d0
		bsr		wrword

		move.l	a0,d0
		bsr		wrlong

		bsr		wrcheck

		bsr		rdchar
		cmp.b		#STUB_NAK,d0
		beq.s		buf0

		bra		stubset

** Sets register address.
stubregs:
		bsr		rdlong
		move.l	d0,d5

		bsr		rdcheck
		bcs		stubnak

		bsr		getregs

		bra		stuback

** Performs OS-9 system call.
stubos9:
		bsr		rdword
		move.w	d0,d2

		bsr		rdlong
		move.l	d0,d5
		
		bsr		rdcheck
		bcs		stubnak

		bsr		wrack

		move.w	d2,d0
		bsr		os9call

		bsr		getregs

os0
		bsr		wrhdr

		move.l	d5,d0
		bsr		wrlong

		bsr		wrcheck

		bsr		rdchar
		cmp.b		#STUB_NAK,d0
		beq.s		os0

		bra		stubreq

** Performs subroutine call.
stubcall:
		bsr		rdlong
		move.w	d0,a0

		bsr		rdlong
		move.l	d0,d5
		
		bsr		wrack

		bsr		copyregs

		bsr		callregs
		
		bsr		cmpregs

		bsr		getregs

call0
		bsr		wrhdr

		move.l	d5,d0
		bsr		wrlong

		bsr		wrcheck

		bsr		rdchar
		cmp.b		#STUB_NAK,d0
		beq.s		call0

		bra		stubreq

** Returns from stub protocol.
stubret:
		rts

** Stub version.
stubver:
		dc.b		" version 0.5.1",13,10,0

		align

		ends

