** @name stubcsd.s Uses first serial device from CSD for SCF character i/o.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		use		<oskdefs.d>
		use		"csdtype.d"

		psect		stubcsd,0,0,0,0,0

CSDLINE	equ	80

** Gets i/o paths.
*
* @return d0.w Input path.
* @return d1.w Output path
* @return a0 Stub version.

iopaths:
* Find serial devices in CSD. 
		moveq		#DT_SERIAL,d2

* Find next device in CSD.
paths1
		move.l	d2,d0
		bsr.s		csdfind
		move.l	d0,d2

* Found device?
		tst.b		(a0)
		beq.s		paths5

* Ignore devices ending in 'x'; the CD-i 605
* CSD will report these in basecase mode, but
* they have the order wrong.
		move.l	a0,a1
paths2
		tst.b		(a1)+
		bne.s		paths2
		cmpi.b	#'x',-2(a1)
		beq.s		paths4

* Try to open the device.
paths3
		moveq		#Read_!Write_,d0
		os9		I$Open
		bcc.s		paths8

* Increment device index and try again.
paths4
		swap		d2
		addq		#1,d2
		swap		d2
		bra.s		paths1

* Try fallback devices.
paths5
		lea		fallback(pc),a1

* Try current fallback device.
paths6
		move.l	a1,a0
		moveq		#Read_!Write_,d0
		os9		I$Open
		bcc.s		paths8

* Skip to next fallback device.
paths7
		tst.b		(a1)+
		bne.s		paths7

* Do we have another fallback device?
		tst.b		(a1)
		bne.s		paths6

* Give up trying.
		moveq		#-1,d0

* Use same path for input and output.
paths8
		move.w	d0,d1
		lea		stubcsd(pc),a0
		rts

** Fallback devices.
fallback:
		dc.b		"/term",0
		dc.b		"/termx",0
		dc.b		"/t2",0
		dc.b		"/t2x",0
		dc.b		"/t1",0
		dc.b		"/t1x",0
		dc.b		0

** Stub version.
stubcsd:
		dc.b		"CD-i Stub",0

		align

		ends
