** @name stubdefs.d Defines "stub" protocol.
*
* @note This file is automatically generated from the {@c stubdefs.h}
* file in the parent directory and should not be edited directly.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/13 cdifan Created.


** @section Introduction.
*
* The "stub" protocol is a means to exchange control and data
* information between a "stub" program and a "host" program.
*
* The programs are typically running on different machines with
* different processors and byte orders; the protocol assumes only
* a transparent byte-sized serial communication channel.
*
* The two programs communicate by exchanging messages, which can be
* requests, responses, escapes and notifications.
*
* The protocol is written to allow sharing of the communication channel
* with other communications; to make this easier all protocol messages
* start with ASCII control bytes that are not normally used in typical
* serial communication. An escape mechanism allows sending of arbitrary
* bytes without any "stub" protocol interpretation.
*
* The protocol is asymmetric in that the "stub" program is expected
* to passively await requests from the "host" program to which it
* will then send responses or notifications. Escapes can be
* sent asynchronously by both programs between the messages.
*
* Every message starts with a header byte which is an ASCII control byte
* that indicates the class of the message. For notifications no
* further bytes are sent, the single control byte is the message.
*
* For requests and responses a message type byte is sent next.
* The rest of the message is determined by the message type byte,
* but all requests and responses end with a message check byte
* calculated over all the preceding message bytes. On reception,
* the check byte is recalculated and compared, mismatches will
* cause the message to be negatively acknowledged or silently ignored.
*
* Escapes are special requests or responses that can be sent at
* any time between other messages without any protocol interpretation.
* They do end with a message check byte but are never acknowledged.
*
* The header byte for all requests is {@c SOH} (start of heading).
* The header byte for all responses is {@c DLE} (data link escape).
* The single byte for notifications is always one of
* {@ul
* @li {@c NAK} (negative acknowledgement),
* @li {@c ACK} (positive acknowledgement) or
* @li {@c CAN} (cancel) or
* @li {@c EM} (end message).
* }
*
* The generic syntax of protocol messages is thus:
*
* {@c Request: SOH type.b data.b[*] check.b}
*
* {@c Response: DLE type.b data.b[*] check.b}
*
* {@c Notification: NAK | ACK | CAN | EM}
*
* The syntax and semantics of each messages are described with
* the definition of the message type bytes below.
*
* The notifications have the following meaning:
* {@dl
* @dt NAK @dd Message unknown or check byte mismatch;
* original sender should resend same message.
* @dt ACK @dd Message processed correctly;
* original sender should continue with next message.
* @dt CAN @dd Message processed correctly but operation canceled;
* original sender should continue with next message.
* @dt EM @dd Program execution complete;
* original sender should continue with next message.
* }
*
* Most Philips CD-i players support a subset of the "stub"
* protocol called the download subset, consisting of just the
* messages needed to download data and/or programs into the player
* and execute programs or continue the player boot process.
*
* The download subset consists of the following requests:
* {@c WRITE}, {@c ADDRESS}, {@c EXECUTE} and {@c END}.
*
* The full "stub" protocol as specified below
* also allows uploading of data and/or programs,
* arbitrary data communication outside the "stub" protocol,
* allocating a data buffer, setting register values,
* performing OS-9 system calls and calling subroutines.
* 
* Additional requests may be specified at some point to support
* full remote debugging including running a program and
* breaking from it, tracing instructions, setting breakpoints
* and manipulating exception vectors.



** @section ASCII control bytes.

** Null byte (ASCII "null").
STUB_NUL	equ	$00

** Request header byte (ASCII "start of heading").
STUB_SOH	equ	$01

** Response header byte (ASCII "data link escape")
STUB_DLE	equ	$10

** Negative acknowledgement byte (ASCII "negative acknowledgement")
STUB_NAK	equ	$15

** Positive acknowledgement byte (ASCII "acknowledgement")
STUB_ACK	equ	$06

** Cancel byte (ASCII "cancel")
STUB_CAN	equ	$14

** End of message byte (ASCII "end of message")
STUB_EM	equ	$19

** @section Message types.

** Writes data.
*
* {@c Write: SOH WRITE size.w data.b[size] check.b -> NAK | ACK}
*
* Writes the specified data bytes to memory at the current address.
* The current address is automatically advanced if the message
* is positively acknowledged; bad data may have been written
* to memory when the message is negatively acknowledged.
*
* The current address can be set by several requests.
* All of these except {@c ADDRESS} also set a limit on the
* amount of data that can be written; if the limit is exceeded
* any data beyond it will be silently ignored.
*
* Except in the download subset, a size of 1 (byte), 2 (word) or 4 (long)
* with a properly aligned (even byte number for word/long) current address
* will write the data to memory in a single byte/word/long operation
* that will only be performed after the check byte has been verified;
* this can be important when addressing device registers.
*
* In all other cases, data will be written to memory with byte
* operations before the check byte has been verified.

STUB_WRITE equ	$01

** Sets current address.
*
* {@c Address: SOH ADDRESS addr.l check.b -> NAK | ACK}
*
* Sets the current address to the specified value if the
* message is positively acknowledged. No limit is set on
* the amount of data that can be read or written.

STUB_ADDRESS equ	$02

** Executes program.
*
* {@c Execute: SOH EXECUTE addr.l check.b -> NAK | ACK ... [EM]}
*
* Starts program execution at the specified memory address,
* if the message is positively acknowledged. If the program
* returns (this may be after considerable time or even never,
* as indicated by the ... in the syntax above), an end message
* notification is sent.
*
* On an 68000-family machine, the program execution is started
* with a {@c jsr (a0)} instruction to the specified address.
* The program can thus return to the "stub" program by executing
* an {@c rts} instruction. The {@c a4} register contains
* the current address and may be modified by the program;
* on return the new current address is taken from the same register
* without setting a limit on the amount of data to be read or written;
* this can be used to subsequently read data produced by the
* program or to write data to an area prepared by the program.
*
* @note The above register assignments are correct for the
* Philips CD-i 605 player download subset implementation and
* all "stub" program implementations explicitly conforming to
* this specification, but the assignment might differ for
* other CD-i player implementations; this needs to be tested.

STUB_EXECUTE equ	$04

** Ends "stub" program.
*
* {@c End: SOH END check.b -> NAK | ACK}
*
* Ends the "stub" program; further action depends on the
* specific "stub" program implementation.
*
* Philips CD-i player download subset implementations will
* continue starting the CD-i player with all downloaded areas
* passed to the OS-9 kernel as ROM to be searched for valid
* OS-9 memory modules.
*
* If the downloaded OS-9 memory modules include one named {@c play}
* with a sufficiently high revision number, it will be started
* after the booting process instead of the CD-i player shell.

STUB_END equ	$08

** Escapes data.
*
* {@c EscapeHost: SOH ESCAPE data.b check.b}
*
* {@c EscapeStub: DLE ESCAPE data.b check.b}
*
* Sends the specified data byte over the communication channel
* without any interpretation; this must be used to send possible
* header bytes over the channel without protocol interpretation.
* The message is not acknowledged.
*
* This message is not included in the download subset.

STUB_ESCAPE equ	$1B

** Sets baudrate.
*
* {@c Baudrate:
*   SOH BAUDRATE baudrate.l check.b -> NAK |
*   DLE BAUDRATE baudrate.l check.b -> NAK | ACK | CAN
* }
*
* Sets the baudrate for the communication channel.
*
* The "host" sends the desired baudrate in the request;
* use zero for the minimal baudrate supported by the "stub"
* or {@c 7FFFFFFF} for the maximum supported baudrate.
*
* The response contains the maximum baudrate supported
* by the "stub" that does not exceed the desired baudrate;
* this will be zero if the "stub" supports no such baudrate.
* If the "stub" does not support baudrate changes at all
* it will always return a zero baudrate.
*
* The baudrate will only be changed after the "host" positively
* acknowledges a response containing a non-zero baudrate.
*
* This message is not included in the download subset.

STUB_BAUDRATE equ	$80

** Reads data.
*
* {@c Read:
*   SOH READ size.w check.b -> NAK |
*   DLE READ size.w data.b[size] check.b -> NAK | ACK | CAN
* }
*
* Reads data bytes from memory at the current address.
* The current address is automatically advanced if the message
* is positively acknowledged; the returned size is always equal
* to the requested size.
*
* The current address can be set by several requests,
* all of these except {@c ADDRESS} also set a limit on the
* amount of data that can be read from that address. Reading
* beyond the limit will return zeroes.
*
* A size of 2 (word) or 4 (long) with a properly aligned
* (even byte number) current address will read the data
* from memory in a single word or long operation;
* this can be important when addressing device registers.
* In all other cases, data will be read with byte operations.
*
* This message is not included in the download subset.

STUB_READ equ	$81

** Sets buffer address.
*
* {@c Buffer:
*  SOH BUFFER size.w check.b -> NAK | ACK
*  DLE BUFFER size.w addr.l check.b -> NAK | ACK
* }
*
* Sets the current address to a buffer of at least the
* specified size, if positively acknowledged. The address
* is returned in the response. The read and write limits
* are set to the specified size.
*
* The maximum allowable size depends on the "stub" program
* implementation; at least 128 bytes must be supported.
*
* The "stub" program maintains only a single buffer whose
* contents need not be preserved across {@c BUFFER} requests
* because the buffer memory may be reallocated.
*
* This message is not included in the download subset.

STUB_BUFFER equ	$82

** Sets registers address.
*
* {@c Registers: SOH REGISTERS regmask.l check.b -> NAK | ACK
*
* Sets the current address to point to the saved contents of the
* processor registers specified by the register mask. The bits of
* the mask specify the registers as follows:
*
* {@c Dx = x, Ax = 8+x, SSP = 15, USP = 16, PC = 17, SR = 18}
*
* All of these are stored as longs except for {@c SR} which 
* is stored as a word.
* 
* This message is not included in the download subset.

STUB_REGISTERS equ	$83

** Register bits.
REGS_D0	equ	0
REGS_D1	equ	1
REGS_D2	equ	2
REGS_D3	equ	3
REGS_D4	equ	5
REGS_D5	equ	5
REGS_D6	equ	6
REGS_D7	equ	7
REGS_A0	equ	8
REGS_A1	equ	9
REGS_A2	equ	10
REGS_A3	equ	11
REGS_A4	equ	12
REGS_A5	equ	13
REGS_A6	equ	14
REGS_SSP	equ	15
REGS_USP	equ	16
REGS_PC	equ	17
REGS_SR	equ	18
REGS_C		equ	31
 
** Register masks.
REGS_MASK_D0		equ	(1<<REGS_D0)
REGS_MASK_D1		equ	(1<<REGS_D1)
REGS_MASK_D2		equ	(1<<REGS_D2)
REGS_MASK_D3		equ	(1<<REGS_D3)
REGS_MASK_D4		equ	(1<<REGS_D4)
REGS_MASK_D5		equ	(1<<REGS_D5)
REGS_MASK_D6		equ	(1<<REGS_D6)
REGS_MASK_D7		equ	(1<<REGS_D7)
REGS_MASK_A0		equ	(1<<REGS_A0)
REGS_MASK_A1		equ	(1<<REGS_A1)
REGS_MASK_A2		equ	(1<<REGS_A2)
REGS_MASK_A3		equ	(1<<REGS_A3)
REGS_MASK_A4		equ	(1<<REGS_A4)
REGS_MASK_A5		equ	(1<<REGS_A5)
REGS_MASK_A6		equ	(1<<REGS_A6)
REGS_MASK_SSP	equ	(1<<REGS_SSP)
REGS_MASK_USP	equ	(1<<REGS_USP)
REGS_MASK_PC		equ	(1<<REGS_PC)
REGS_MASK_SR		equ	(1<<REGS_SR)
REGS_MASK_C		equ	(1<<REGS_C)

** Performs OS-9 system call.
*
* {@c Os9Call:
*   SOH OS9CALL num.w regmask.l check.b -> NAK | ACK
*   DLE OS9CALL regmask.l check.b -> NAK | ACK
* }
*
* Performs OS-9 system call with the specified number,
* after loading the saved content of the processor registers.
* After the call the processor registers are saved again and
* compared with their previous saved values. The corresponding
* bit in the supplied register mask will be set if a register has
* been changed.  Bit 31 of the register mask will reflect the state
* of the carry flag after the call which indicates an error
* if set. If the carry flag is set, register mask bit 1 for
* the D1 register will also be set because that is where OS-9
* system calls return their error number.
*
* The current address is set to point to the saved contents of the
* processor registers as specified by the final register mask,
* identically to {@c REGISTERS}. However, the register values
* can only be read with {@c READ}.
*
* If a "stub" program does not support OS-9 system calls
* (because OS-9 isn't presently running or not available
* on the machine at all), no operation should be performed
* except returning the register mask of all zeroes except
* for bit 31 being set to indicate an error. As specified above,
* a "stub" program supporting OS-9 system calls will never
* return this register mask because bit 31 will force bit 1.
*
* This message is not included in the download subset.
*
* @note This protocol request is principally redundant as
* the combination of {@c BUFFER} and {@c CALL} allows the
* same effect to be achieved by storing the OS-9 system call
* instruction in the buffer and then executing it. The {@c OS9CALL}
* request is preferred however because it avoids a cumbersome check
* for the availability of OS-9 system calls and allows emulation
* of selected system calls by the "stub" program if so desired.
* The {@c OS9CALL} request is also easier to use and more efficient.

STUB_OS9CALL equ	$84

** Performs subroutine call.
*
* {@c Call:
*   SOH CALL addr.l regmask.l check.b -> NAK | ACK
*   DLE OS9 regmask.l check.b -> NAK | ACK
* }
*
* Performs a call to the specified address
* after loading the saved content of the processor registers.
* After the call the processor registers are saved again and
* compared with their previous saved values. The corresponding
* bit in the supplied register mask will be set if a register has
* been changed. 
*
* The current address is set to point to the saved contents of the
* processor registers as specified by the final register mask,
* identically to {@c REGISTERS}. However, the register values
* can only be read with {@c READ}.
*
* This message is not included in the download subset.
*
* @todo What about bus errors and other exceptions?

STUB_CALL equ	$85

** Runs program.
*
* This message is not included in the download subset.
*
* @todo Specify this message for remote debugging.

STUB_RUN equ	$86

** Breaks program.
*
* This message is not included in the download subset.
*
* @todo Specify this message for remote debugging.

STUB_BREAK equ	$87

** Traces program.
*
* This message is not included in the download subset.
*
* @todo Specify this message for remote debugging.

STUB_TRACE equ	$88

** Manipulates breakpoints.
*
* This message is not included in the download subset.
*
* @todo Specify this message for remote debugging.

STUB_BREAKPOINTS equ	$89

** Manipulates exception vectors.
*
* This message is not included in the download subset.
*
* @todo Specify this message for remote debugging.

STUB_VECTORS equ	$8A

