** @name stubk681.s Implements stub character i/o for 68681 DUART
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		psect		stubk681,0,0,0,0,0,0

MRX	equ	$0					Mode Register X
SRX	equ	$2					Status Register X

SRX_TXRDY	equ	2				Transmitter Ready
SRX_RXRDY	equ	0				Receiver Ready

THRX	equ	$6					Transmit Holding Register X
RHRX	equ	$6					Receive Holding Register X

** Initializes character i/o
*
* @return a0 Stub version.

ioinit:
		bsr		ioport
		move.l	a3,uart(a6)
		rts

** Checks character i/o baudrate.
*
* @param d0.l Desired baudrate.
* @return d0.l Supported baudrate.
* @return d2.l Supported baudrate code

iocheck:
		moveq		#0,d0
		rts

** Sets character i/o baudrate.
*
* @param d2.l Supported baudrate code.

iobaud:
		moveq		#0,d2
		rts

** Reads character.
*
* @return d0.b = character

rdchar:
		move.l	a3,-(sp)
		move.l	uart(a6),a3

rdwait
		btst.b	#SRX_RXRDY,SRX(a3)
		beq.s		rdwait

		move.b	RHRX(a3),d0

		move.l	(sp)+,a3
		rts

** Writes character.
*
* @param d0.b = character

wrchar:
		move.l	a3,-(sp)
		move.l	uart(a6),a3

wrwait
		btst.b	#SRX_TXRDY,SRX(a3)
		beq.s		wrwait

		move.b	d0,THRX(a3)

		move.l	(sp)+,a3
		rts
		
		vsect

** Address of 68681 UART port.
uart:		ds.l		1

		ends

		ends

