** @name stubk70.s Implements stub character i/o for 68070 on-chip UART
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		psect		stubk70,0,0,0,0,0

UART	equ	$80002010		Base address of UART

UMR	equ	$1					UART Mode Register
USR	equ	$3					UART Status Register

USR_TXRDY	equ	2				Transmitter Ready
USR_RXRDY	equ	0				Receiver Ready

UCR	equ	$7					UART Command Register

UTH	equ	$9					UART Transmit Holding Register
URH	equ	$B					UART Receive Holding Register

** Initializes character i/o
*
* @return a0 Stub version.

ioinit:
		lea		stubk70(pc),a0
		rts

** Checks character i/o baudrate.
*
* @param d0.l Desired baudrate.
* @return d0.l Supported baudrate.
* @return d2.l Supported baudrate code

iocheck:
		moveq		#0,d0
		rts

** Sets character i/o baudrate.
*
* @param d2.l Supported baudrate code.

iobaud:
		moveq		#0,d2
		rts

** Reads character.
*
* @return d0.b = character
** Reads character.
*
* @return d0.b = character

rdchar:
		move.l	a3,-(sp)
		move.l	#UART,a3

rdwait
		btst.b	#USR_RXRDY,USR(a3)
		beq.s		rdwait

		move.b	URH(a3),d0

		move.l	(sp)+,a3
		rts

** Writes character.
*
* @param d0.b = character

wrchar:
		move.l	a3,-(sp)
		move.l	#UART,a3

wrwait
		btst.b	#USR_TXRDY,USR(a3)
		beq.s		wrwait

		move.b	d0,UTH(a3)

		move.l	(sp)+,a3
		rts
		
** Stub version.
stubk70:
		dc.b			"68070 Stub",0

		align

		ends

