** @name stubmod.s Stub program as a module for OS-9 operating system.
*
* This file implements the stub program for a machine running OS-9,
* using OS-9 services for memory allocation.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		use <oskdefs.d>
		
TypeLang	equ	(Prgrm<<8)!Objct
AttrRev	equ	(ReEnt<<8)!255

Edit		equ	1
Stack		equ	8192

		psect		stubmod,TypeLang,AttrRev,Edit,Stack,start
		
** Entry point of stub program.

start:
		bsr.s		stub

		moveq		#0,d0
		os9		F$Exit

start1
		bra.s		start1

** Processes data byte.
*
* @param d0.b Data byte.

prdata:
		rts

** Allocates buffer.
*
* @param d0.l Requestd buffer size.
* @return d0.l Actual buffer size.
* @return a0 Buffer address.

allocbuf:
		cmp.l		bufsize(a6),d0
		blo.s		alloc2

		move.l	d0,d2
		move.l	bufsize(a6),d0
		beq.s		alloc1

		move.l	bufptr(a6),a0
		os9		F$SRtMem

alloc1
		clr.l		bufsize(a6)
		clr.l		bufptr(a6)

		move.l	d2,d0
		os9		F$SRqMem
		bcs.s		alloc2

		move.l	d0,bufsize(a6)
		move.l	a2,bufptr(a6)

alloc2
		move.l	bufsize(a6),d0
		move.l	bufptr(a6),a0
		rts

TRAP0	equ		$4E40
RTS	equ		$4E75

** Performs OS-9 system call.
*
* @param d0.w System call number
* @param d5.l Register mask.
* @return d5.l Updated register mask.

os9call:
		lea		os9buf(a6),a0
		move.w	#TRAP0,(a0)+
		move.w	d0,(a0)+
		move.w	#RTS,(a0)+

		bsr		copyregs

		lea		os9buf(a6),a0
		bsr		callregs
		
		bsr		chkregs
		bsr		cmpregs

		rts

		vsect

** Buffer pointer.
bufptr:		ds.l		1

** Buffer size.
bufsize:		ds.l		1

** OS-9 system call buffer.
os9buf:		ds.w		3

		ends

		ends
