** @name stubraw.s Stub program as raw binary without operating system.
*
* This file implements the stub program for a raw machine,
* without using any operating system services. 
*
* @author CD-i Fan

		use		<oskdefs.d>

TypeLang	equ	(Prgrm<<8)!Objct
AttrRev	equ	(ReEnt<<8)!1

		psect		stubraw,TypeLang,AttrRev,0,0,start

** Static buffer size.
BUFSIZE	equ	128
		
** Entry point of stub program.
*
* We assume a valid stack pointer but nothing else;
* all variables are allocated on the stack.

start:
		movem.l	d0-d7/a0-a6,-(sp)
		
		move.l	sp,a0
		sub.l		#end+2,sp
		move.l	sp,a6
		move.l	a0,savesp(a6)

		bsr.s		stub

		move.l	savesp(a6),sp

		movem.l	(sp)+,d0-d7/a0-a6
		rts
	
** Processes data byte.
*
* @param d0.b Data byte.

prdata:
		rts

** Allocates buffer.
** Allocates buffer.
*
* @param d0.l Requested buffer size.
* @return d0.l Actual buffer size.
* @return a0 Buffer address.

allocbuf:
		cmp.l		#BUFSIZE,d0
		blo.s		alloc1
		moveq		#0,d0
		move.l	d0,a0
		bra.s		alloc2
alloc1
		move.l	#BUFSIZE,d0
		lea		buf(a6),a0
alloc2
		rts

** Performs OS-9 system call.
*
* @param d0.w System call number
* @param d5.l Register mask.
* @return d5.l Updated register mask.

os9call:
		move.l	#$80000000,d5
		rts
							
		vsect

** Saved stack pointer.
savesp:		ds.l		1

** Static buffer.
buf:			ds.b		BUFSIZE

		ends

		ends
