** @name stubregs.s Implements register subroutines.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		use		"stubdefs.d"

		psect		stubregs,0,0,0,0,0

** Register offsets.
R_A5		equ	4*REGS_A5
R_A6		equ	4*REGS_A6
R_SSP		equ	4*REGS_SSP
R_USP		equ	4*REGS_USP
R_PC		equ	4*REGS_PC
R_SR		equ	4*REGS_SR

** Status register bits.
SR_C		equ	0
SR_S		equ	13

** Initializes registers.
*
* This function initializes the saved registers
* to zero except for the high byte of the status register.

initregs:
		lea		regs(a6),a0
		moveq		#0,d1
init1
		clr.l		(a0)+
		addq		#1,d1
		cmp.w		#REGS_SR,d1
		blt.s		init1
		move.w	sr,d0
		clr.b		d0
		move.w	d0,(a0)+

		lea		regs(a6),a5
		btst		#SR_S,d0
		beq.s		init2
		move.l	sp,R_SSP(a5)
		bra.s		init3
init2
		move.l	sp,R_USP(a5)
init3
		rts

** Copies registers.
*
* Copies saved registers to register buffer. 

copyregs:
		lea		regs(a6),a0
		lea		regsbuf(a6),a1
		moveq		#0,d1
copy1
		move.l	(a0)+,(a1)+
		addq		#1,d1
		cmp.w		#REGS_SR,d1
		blt.s		copy1
		move.w	(a0)+,(a1)+
		rts

** Compares registers.
*
* Compares saved registers to register buffer
* and updates the register mask where different.
*
* @param d5.l Register mask.
* @return d5.l Updated register mask.

cmpregs:
		lea		regs(a6),a0
		lea		regsbuf(a6),a1
		moveq		#0,d1
cmp1
		move.l	(a0)+,d0
		cmp.l		(a1)+,d0
		beq.s		cmp2
		bset		d1,d5
cmp2
		addq		#1,d1
		cmp.w		#REGS_SR,d1
		blt.s		cmp1
		move.w	(a0)+,d0
		cmp.w		(a1)+,d0
		beq.s		cmp3
		bset		d1,d5
cmp3
		rts

** Checks registers.
*
* Checks the save registers for OS-9 errors
* and modified the register mask accordingly.
*
* @param d5.l Register mask.
* @return d5.l Updated register mask.

chkregs:
		lea		regs(a6),a5
		move.w	R_SR(a5),d0
		btst		#SR_C,d0
		beq.s		chk1
		bset		#REGS_C,d5
		bset		#REGS_D1,d5
chk1
		rts

** Gets registers.
*
* Gets specified saved registers into register buffer,
* and prepares for reading/writing the buffer.
*
* @param d5.l Register mask.
* @return a3 Write complete routine.
* @return a4 Register buffer.
* @return d3 Register bytes.
* @return d4 Register bytes.

getregs:
		lea		setregs(pc),a3
		lea		regsbuf(a6),a4
		moveq		#0,d3
		moveq		#0,d4

		lea		regs(a6),a0
		lea		regsbuf(a6),a1
		moveq		#0,d1
get1
		move.l	(a0)+,d0
		btst		d1,d5
		beq.s		get2
		move.l	d0,(a1)+
		addq		#4,d3
		addq		#4,d4
get2
		addq		#1,d1
		cmp.w		#REGS_SR,d1
		blt.s		get1
		move.w	(a0)+,d0
		btst		d1,d5
		beq.s		get3
		move.w	d0,(a1)+
		addq		#2,d3
		addq		#2,d4
get3
		rts

** Sets registers.
*
* Sets specified registers from register buffer.
*
* @param d5.l Register mask.

setregs:
		lea		regs(a6),a0
		lea		regsbuf(a6),a1
		moveq		#0,d1
set1
		move.l	(a0),d0
		btst		d1,d5
		beq.s		set2
		move.l	(a1)+,d0
set2
		move.l	d0,(a0)+
		addq		#1,d1
		cmp.w		#REGS_SR,d1
		blt.s		set1
		move.w	(a0),d0
		btst		d1,d5
		beq.s		set3
		move.w	(a1)+,d0
set3
		move.w	d0,(a0)+
		rts

** Calls registers.
*
* This function loads the saved registers
* and calls a function at a specified address.
*
* When the function returns, the registers will be saved.
*
* @param a0 Address of function to call.

callregs:
		lea		regs(a6),a5
		moveq		#R_SSP,d2
		move.w	R_SR(a5),d0
		btst		#SR_S,d0
		bne.s		call1
		moveq		#R_USP,d2
call1
		move.l	(a5,d2.w),-(sp)
		move.l	R_PC(a5),-(sp)

		movem.l	d2-d7/a3-a4,-(sp)
		move.l	a6,-(sp)

		lea		-4(sp),a1
		move.l	a1,(a5,d2.w)
		move.l	a0,R_PC(a5)

		bsr.s		execregs

		move.w	sr,-(sp)
		move.l	a6,-(sp)
		move.l	a5,-(sp)

		move.l	10(sp),a6
		lea		regs(a6),a5

		movem.l	d0-d7/a0-a4,(a5)

		move.l	0(sp),R_A5(a5)
		move.l	4(sp),R_A6(a5)
		move.w	8(sp),R_SR(a5)

		add.w		#14,sp
		movem.l	(sp)+,d2-d7/a3-a4

		move.l	(sp)+,R_PC(a5)
		move.l	(sp)+,(a5,d2.w)

		rts

** Executes registers.
*
* This function loads the saved registers
* and starts execution at the saved PC value.
*
* This function will not return unless prior
* arrangements have been made.

execregs:
		lea		regs(a6),a5
		move.l	R_SSP(a5),sp
		move.w	R_SR(a5),d0
		btst		#SR_S,d0
		bne.s		exec1
		move.l	R_USP(a5),sp
exec1
		move.l	R_PC(a5),-(sp)
		move.w	R_SR(a5),-(sp)
		move.w	sr,d0
		btst		#SR_S,d0
		beq.s		exec3
exec2
		move.w	#0,-(sp)
		movem.l	regs(a6),d0-d7/a0-a6
		rte
exec3
		movem.l	regs(a6),d0-d7/a0-a6
		rtr

		vsect

** Saved registers.
regs:			ds.l		REGS_SR
				ds.w		1

** Registers buffer for read/write.
regsbuf:		ds.l		REGS_SR
				ds.w		1

		ends

