** @name stubscf.s Implements stub character i/o using OS-9 SCF.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		psect		stubscf,0,0,0,0,0

** Initializes character i/o
*
* @return a0 Stub version.

ioinit:
		bsr		iopaths
		move.w	d0,inpath(a6)
		move.w	d1,outpath(a6)
		move.l	a0,a2

		move.w	inpath(a6),d0
		bsr.s		setraw
		move.w	outpath(a6),d0
		bsr.s		setraw

		move.l	a2,a0
		rts

setraw:
		bsr.s		getopt
		bcs.s		set1
		
		tst.b		PD_DTP-PD_OPT(a0)
		bne.s		set1

		clr.b		PD_UPC-PD_OPT(a0)
		clr.b		PD_BSO-PD_OPT(a0)
		clr.b		PD_DLO-PD_OPT(a0)
		clr.b		PD_EKO-PD_OPT(a0)
		clr.b		PD_ALF-PD_OPT(a0)
		clr.b		PD_NUL-PD_OPT(a0)
		clr.b		PD_PAU-PD_OPT(a0)
		clr.b		PD_BSP-PD_OPT(a0)
		clr.b		PD_DEL-PD_OPT(a0)
		clr.b		PD_EOR-PD_OPT(a0)
		clr.b		PD_EOF-PD_OPT(a0)
		clr.b		PD_RPR-PD_OPT(a0)
		clr.b		PD_DUP-PD_OPT(a0)
		clr.b		PD_PSC-PD_OPT(a0)
		clr.b		PD_INT-PD_OPT(a0)
		clr.b		PD_QUT-PD_OPT(a0)
		clr.b		PD_BSE-PD_OPT(a0)
		clr.b		PD_OVF-PD_OPT(a0)
		clr.b		PD_XON-PD_OPT(a0)
		clr.b		PD_XOFF-PD_OPT(a0)

setopt:
		move.w	#SS_Opt,d1
		os9		I$SetStt
set1
		rts

getopt:
		lea		optbuf(a6),a0
		move.w	#SS_Opt,d1
		os9		I$GetStt
		rts

** Checks character i/o baudrate.
*
* @param d0.l Desired baudrate.
* @return d0.l Supported baudrate.
* @return d2.l Supported baudrate code

iocheck:
		lea		baudrates(pc),a1
		move.l	d0,-(sp)
		moveq		#0,d0
		moveq		#-1,d2
check1
		move.l	(a1)+,d1
		beq.s		check3
		tst.l		(sp)
		beq.s		check2
		cmp.l		(sp),d1
		bhi.s		check3
check2
		move.l	d1,d0
		addq		#1,d2
		tst.l		(sp)
		bne.s		check1
check3
		addq		#4,sp
		rts

** Sets character i/o baudrate.
*
* @param d2.l Supported baudrate code.

iobaud:
		move.w	inpath(a6),d0
		bsr.s		setbaud
		move.w	outpath(a6),d0

setbaud:
		bsr.s		getopt
		bcs.s		set1
		move.b	d2,PD_BAU-PD_OPT(a0)
		clr.b		PD_PAR-PD_OPT(a0)
		bra.s		setopt

baudrates:
		dc.l		50
		dc.l		75
		dc.l		110
		dc.l		134
		dc.l		150
		dc.l		300
		dc.l		600
		dc.l		1200
		dc.l		1800
		dc.l		2000
		dc.l		2400
		dc.l		3600
		dc.l		4800
		dc.l		7200
		dc.l		9600
		dc.l		19200
		dc.l		38400
		dc.l		0

** Reads character.
*
* @return d0.b = character

rdchar:
		movem.l	d0-d1/a0,-(sp)

		move.w	inpath(a6),d0
		moveq		#1,d1
		lea		3(sp),a0

		os9		I$Read
		bcs.s		rdchar1
		cmp.l		#1,d1
		beq.s		rdchar2
rdchar1
		clr.b		3(sp)
rdchar2
		
		movem.l	(sp)+,d0-d1/a0
		rts

** Writes character.
*
* @param d0.b = character

wrchar:
		movem.l	d0-d1/a0,-(sp)

		move.w	outpath(a6),d0
		moveq		#1,d1
		lea		3(sp),a0
		os9		I$Write

		movem.l	(sp)+,d0-d1/a0
		rts

		vsect

inpath:		ds.w		1

outpath:		ds.w		1

optbuf:		ds.b		128

		ends

		ends

