** @name stubsubs.s Implements stub subroutines.
*
* @section Copyright (c) 2005, CD-i Fan.
* This file is licensed under the GNU Library General Public License,
* version 2 or (at your option) any later version. The full terms of
* the license can be found in the file LCOPYING that you should have
* received with this file. You can also refer to the on-line version that
* can be found at http://www.fsf.org/licensing/licenses/lgpl.txt.
*
* @author CD-i Fan
*
* @version 0.5.1
*
* @history
* @rev 2005/03/20 cdifan Created

		use		"stubdefs.d"

		psect		stubsubs,0,0,0,0,0

** Reads byte.
*
* @param d6.b Check byte.
* @return d0.b Byte read.
* @return d6.b Updated check byte.

rdbyte:
		bsr		rdchar
		eor.b		d0,d6
		rts

** Reads check byte.
*
* @return ccr.c Set on check byte error.

rdcheck:
		bsr.s		rdbyte
		tst.b		d6
		beq.s		rdchk1
		ori.b		#1,ccr
rdchk1
		rts

** Writes check byte.
*
* @param d6.b Check byte.

wrcheck:
		move.b	d6,d0
* fall through

** Writes byte.
*
* @param d0.b Byte to be written.
* @param d6.b Check byte.
* @return d6.b Updated check byte.

wrbyte:
		bsr		wrchar
		eor.b		d0,d6
		rts

** Reads long.
*
* @param d6.b Check byte.
* @return d0.l Value read.
* @return d1 Changed.
* @return d6.b Updated check byte.

rdlong:
		moveq		#4,d1
		bra.s		rdvalue

** Reads word.
*
* @param d6.b Check byte.
* @return d0.l Value read.
* @return d1 Changed.
* @return d6.b Updated check byte.

rdword:
		moveq		#2,d1
* fall through

** Reads value.
*
* @param d1.w Number of value bytes.
* @param d6.b Check byte.
* @return d0.l Value read.
* @return d1 Changed.
* @return d6.b Updated check byte.

rdvalue:
		moveq		#0,d0
		subq		#1,d1
rdval1
		rol.l		#8,d0
		bsr.s		rdbyte
		dbra		d1,rdval1
		rts

** Writes long.
*
* @param d0.l Value to write.
* @param d6.b Check byte.
* @return d1 Changed.
* @return d6.b Updated check byte.

wrlong:
		moveq		#4,d1
		bra.s		wrvalue

** Writes word.
*
* @param d0.l Value to write.
* @param d6.b Check byte.
* @return d1 Changed.
* @return d6.b Updated check byte.

wrword:
		moveq		#2,d1
* fall through

** Writes value.
*
* @param d0.l Value to write.
* @param d1.w Number of value bytes.
* @param d6.b Check byte.
* @return d1 Changed.
* @return d6.b Updated check byte.

wrvalue:
		subq		#1,d1
		move.w	d1,-(sp)
		eori.w	#3,d1
wrval1
		rol.l		#8,d0
		dbra		d1,wrval1
		move.w	(sp)+,d1
wrval2
		bsr.s		wrbyte
		rol.l		#8,d0
		dbra		d1,wrval2
		rts

** Writes positive acknownledgement.

wrack:
		moveq		#STUB_ACK,d0
		bra		wrchar

** Writes response header.
*
* @return d6.b Updated check byte.

wrhdr:
		clr.b		d6

		moveq		#STUB_DLE,d0
		bsr.s		wrbyte

		swap		d6
		move.b	d6,d0
		swap		d6
		bra.s		wrbyte

** Writes text.
*
* @param a0 Pointer to text.
* @return a0 Updated past text.
* @return d0 Changed.

wrtxt1
		bsr		wrchar
wrtext:
		move.b	(a0)+,d0
		bne.s		wrtxt1
		rts

		ends

